#!/bin/osmtKsh
#!/bin/osmtKsh

typeset RcsId="$Id: lcntProc.sh,v 1.1 2011/01/05 07:09:21 lsipusr Exp $"


if [ "${loadFiles}X" == "X" ] ; then
  seedLcntProc.sh -l $0 "$@"
  exit $?
fi

function buildPre {
  #if [[ ! -d tables ]] ; then ln -s ../Q1-2007-BusPlan/tables tables; fi
  #if [[ ! -d figures ]] ; then ln -s ../figures figures; fi
  return
}

function buildPost {
    vis_allExtrasBuild
}


function cleanPost {
    vis_allExtrasClean
}


function examplesHookPost {
    here=$( pwd )
#file://${here}/gharbzadegiFull.html
cat  << _EOF_
--- ALL EXTRAs  ---
${G_myName} ${extraInfo} -i allExtras
--- EXTRAS ---
${G_myName} ${extraInfo} -i xelatexProc presentationFa.ttytex
${G_myName} ${extraInfo} -i xelatexProc articleFa.ttytex
---
opTexNedaBuild.sh -p cleanType=realclean -i clean presentationFa.ttytex
opTexNedaBuild.sh -p cleanType=realclean -i clean articleFa.ttytex
---
opTexNedaBuild.sh -p outputs=onehtml -i buildDocs  presentationFa.ttytex
opTexNedaBuild.sh -p outputs=onehtml -i buildDocs  articleFa.ttytex
---
${G_myName} ${extraInfo} -i latexSourcesTar
_EOF_

 return
}


function vis_allExtrasBuild {
  vis_xelatexProc presentationFa.ttytex
  vis_xelatexProc articleFa.ttytex

  vis_sourcesTar
}


function vis_allExtrasClean {
    opTexNedaBuild.sh -p cleanType=realclean -i clean presentationFa.ttytex
    opTexNedaBuild.sh -p cleanType=realclean -i clean articleFa.ttytex

    /bin/rm LaTeXsources.tar 2> /dev/null
}



function vis_oneHtml {
    opTexNedaBuild.sh -p outputs=onehtml -i buildDocs  docLatex.ttytex
    cp one-docLatex/docLatex.html  main.html
    #/opt/public/osmt/bin/elispFilterFarsiHtml.sh -i farsiOneHtml main
  return
}

function vis_xelatexProc {
  function describeF {  cat  << _EOF_
    # arg1 topInFile
_EOF_
  }

 EH_assert [[ $# -eq 1 ]]

 inFile=$1

 EH_assert [[ -f ${inFile} ]]

 xelatex ${inFile}
 xelatex ${inFile}
  return
}

function vis_sourcesTar {
    tar cvf LaTeXsources.tar presentationEn.ttytex presentationFa.ttytex articleFa.ttytex articleEn.ttytex bodyEn.tex bodyFa.tex lcntProc.sh 
}



function lcntInputProc {
  function describeF {  cat  << _EOF_
    # arg1 topInFile
    # arg2 fmt
    # arg3 out1
    # ...  outN
_EOF_
  }

 EH_assert [[ $# -ge 3 ]]

 inFile=$1
 inFmt=$2

 EH_assert [[ -f ${inFile} ]]

 # NOTYET, lcnLcntInputProc.sh will replace opTexNedaBuild.sh
  return
}
